<?php

$options = [
	blocksy_rand_md5() => [
		'title' => __( 'General', 'blocksy' ),
		'type' => 'tab',
        'options' => array_merge(
			[
				'header_button_type' => [
					'label' => false,
					'type' => 'ct-image-picker',
					'value' => 'type-1',
					'choices' => [

						'type-1' => [
							'src'   => blocksy_image_picker_file( 'button-1' ),
							'title' => __( 'Default', 'blocksy' ),
						],

						'type-2' => [
							'src'   => blocksy_image_picker_file( 'button-2' ),
							'title' => __( 'Ghost', 'blocksy' ),
						],

					],
				],

				'header_button_size' => [
					'label' => __('Size', 'blocksy'),
					'type' => 'ct-select',
					'value' => 'small',
					'view' => 'text',
					'design' => 'inline',
					'divider' => 'top',
					'choices' => blocksy_ordered_keys(
						[
							'default' => __( 'Default', 'blocksy' ),
							'small' => __( 'Small', 'blocksy' ),
							'medium' => __( 'Medium', 'blocksy' ),
							'large' => __( 'Large', 'blocksy' ),
						]
					),
				],

				'header_button_text' => [
					'label' => __( 'Label Text', 'blocksy' ),
					'type' => 'text',
					'design' => 'inline',
					'divider' => 'top',
					'value' => __( 'Download', 'blocksy' ),
				],

				'has_header_button_secondary_text' => [
					'label' => __( 'Secondary Label', 'blocksy' ),
					'type'  => 'ct-switch',
					'value' => 'no',
					'divider' => 'top',
				],

				blocksy_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'has_header_button_secondary_text' => 'yes' ],
					'options' => [

						'header_button_secondary_text' => [
							'label' => __( 'Label Text', 'blocksy' ),
							'type' => 'text',
							'design' => 'inline',
							'value' => __( 'Hurry Up!', 'blocksy' ),
							'divider' => 'bottom',
						],

						'header_button_text_horizontal_alignment' => [
							'type' => 'ct-radio',
							'label' => __( 'Text Alignment', 'blocksy' ),
							'view' => 'text',
							'design' => 'block',
							'responsive' => true,
							'attr' => [ 'data-type' => 'alignment' ],
							'setting' => [ 'transport' => 'postMessage' ],
							'value' => 'CT_CSS_SKIP_RULE',
							'choices' => [
								'left' => '',
								'center' => '',
								'right' => '',
							],
						],

					],
				],

				blocksy_rand_md5() => [
					'type' => 'ct-divider',
				],

				'header_button_open' => [
					'label' => __('Click Behavior', 'blocksy'),
					'type' => (
						function_exists('blc_fs')
						&&
						blc_fs()->can_use_premium_code()
					) ? 'ct-select' : 'hidden',
					'value' => 'link',
					'view' => 'text',
					'design' => 'inline',
					'choices' => [
						'link' => __('Open Link', 'blocksy'),
						'popup' => __('Open Popup', 'blocksy'),
					],
				],

				blocksy_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'header_button_open' => '!popup' ],
					'options' => [

						'header_button_link' => [
							'label' => __( 'Link/URL', 'blocksy' ),
							'type' => 'text',
							'design' => 'inline',
							'value' => '#',
						],

						'header_button_target' => [
							'label' => __( 'Open in new tab', 'blocksy' ),
							'type'  => 'ct-switch',
							'value' => 'no',
							'divider' => 'top',
						],

						'header_button_nofollow' => [
							'type'  => 'ct-switch',
							'label' => __( 'Set link to nofollow', 'blocksy' ),
							'value' => 'no',
						],

						'header_button_sponsored' => [
							'type'  => 'ct-switch',
							'label' => __( 'Set link to sponsored', 'blocksy' ),
							'value' => 'no',
						],

					],
				],

				blocksy_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'header_button_open' => 'popup' ],
					'options' => (
						function_exists('blc_get_content_blocks')
						&&
						! empty(blc_get_content_blocks([
							'template_type' => 'popup'
						]))
					) ? [
						'header_button_select_popup' => [
							'label' => __('Popup Template', 'blocksy' ),
							'type' => 'ct-select',
							'design' => 'inline',
							'value' => '',
							'search' => true,
							'defaultToFirstItem' => false,
							'placeholder' => __('None', 'blocksy'),
							'choices' => blocksy_ordered_keys(blc_get_content_blocks([
								'template_type' => 'popup'
							])),
						],
					] : [
						blocksy_rand_md5() => [
							'type' => 'html',
							'label' => __('Popup Template', 'blocksy'),
							'value' => '',
							'design' => 'inline',
							'html' => '<a href="' . admin_url('/edit.php?post_type=ct_content_block') .'" target="_blank" class="button" style="width: 130px; text-align: center;">' . __('Create Popup', 'blocksy') . '</a>',
						],
					],
				],
			],

			apply_filters(
				'blocksy:header:button:options:after-link-options',
				[]
			),

			$panel_type === 'header' ? [
				blocksy_rand_md5() => [
					'type' => 'ct-condition',
					'condition' => [ 'wp_customizer_current_view' => 'tablet|mobile' ],
					'options' => [
						'visibility' => [
							'label' => __( 'Element Visibility', 'blocksy' ),
							'type' => 'ct-visibility',
							'design' => 'block',
							'divider' => 'top:full',
							'allow_empty' => true,
							'value' => blocksy_default_responsive_value([
								'tablet' => true,
								'mobile' => true,
							]),
							'choices' => blocksy_ordered_keys([
								'tablet' => __( 'Tablet', 'blocksy' ),
								'mobile' => __( 'Mobile', 'blocksy' ),
							]),
							'setting' => [ 'transport' => 'postMessage' ],
						],
					],
				],
			] : [],

			$panel_type === 'footer' ? [
				'footer_button_horizontal_alignment' => [
					'type' => 'ct-radio',
					'label' => __( 'Horizontal Alignment', 'blocksy' ),
					'view' => 'text',
					'design' => 'block',
					'divider' => 'top:full',
					'responsive' => true,
					'attr' => [ 'data-type' => 'alignment' ],
					'setting' => [ 'transport' => 'postMessage' ],
					'value' => 'CT_CSS_SKIP_RULE',
					'choices' => [
						'flex-start' => '',
						'center' => '',
						'flex-end' => '',
					],
				],

				'footer_button_vertical_alignment' => [
					'type' => 'ct-radio',
					'label' => __( 'Vertical Alignment', 'blocksy' ),
					'view' => 'text',
					'design' => 'block',
					'divider' => 'top',
					'responsive' => true,
					'attr' => [ 'data-type' => 'vertical-alignment' ],
					'setting' => [ 'transport' => 'postMessage' ],
					'value' => 'CT_CSS_SKIP_RULE',
					'choices' => [
						'flex-start' => '',
						'center' => '',
						'flex-end' => '',
					],
				],

				'visibility' => [
					'label' => __( 'Element Visibility', 'blocksy' ),
					'type' => 'ct-visibility',
					'design' => 'block',
					'sync' => 'live',
					'divider' => 'top',
					'value' => blocksy_default_responsive_value([
						'desktop' => true,
						'tablet' => true,
						'mobile' => true,
					]),
					'choices' => blocksy_ordered_keys([
						'desktop' => __( 'Desktop', 'blocksy' ),
						'tablet' => __( 'Tablet', 'blocksy' ),
						'mobile' => __( 'Mobile', 'blocksy' ),
					]),
				],
			] : [],

			[
				'user_visibility' => [
					'label' => __( 'User Visibility', 'blocksy' ),
					'type' => 'ct-checkboxes',
					'design' => 'block',
					'view' => 'text',
					'divider' => 'top:full',
					'value' => [
						'logged_in' => true,
						'logged_out' => true,
					],
					'choices' => blocksy_ordered_keys([
						'logged_in' => __( 'Logged In', 'blocksy' ),
						'logged_out' => __( 'Logged Out', 'blocksy' ),
					]),
				],
			],

			[
				'header_button_class' => [
					'label' => __( 'CSS Class', 'blocksy' ),
					'type' => 'text',
					'design' => 'block',
					'divider' => 'top:full',
					'value' => '',
					'desc' => __( 'Separate multiple classes with spaces.', 'blocksy' ),
				],

				'button_aria_label' => [
					'label' => __( 'Custom Aria Label', 'blocksy' ),
					'type' => 'text',
					'design' => 'block',
					'divider' => 'top',
					'value' => '',
					'desc' => blocksy_safe_sprintf(
						// translators: placeholder here means the actual URL.
						__( 'Add a custom %saria label%s attribute.', 'blocksy' ),
						blocksy_safe_sprintf(
							'<a href="https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Attributes/aria-label" target="_blank">'
						),
						'</a>'
					),
				],
			]
		)
	],

	blocksy_rand_md5() => [
		'title' => __( 'Design', 'blocksy' ),
		'type' => 'tab',
		'options' => [

			'headerButtonFont' => [
				'type' => 'ct-typography',
				'label' => __( 'Label Text Font', 'blocksy' ),
				'value' => blocksy_typography_default_values([]),
				'setting' => [ 'transport' => 'postMessage' ],
			],

			blocksy_rand_md5() => [
				'type' => 'ct-labeled-group',
				'label' => __( 'Label Text Color', 'blocksy' ),
				'divider' => 'bottom',
				'responsive' => true,
				'choices' => [
					[
						'id' => 'headerButtonFontColor',
						'label' => __('Default State', 'blocksy')
					],

					[
						'id' => 'transparentHeaderButtonFontColor',
						'label' => __('Transparent State', 'blocksy'),
						'condition' => [
							'row' => '!offcanvas',
							'builderSettings/has_transparent_header' => 'yes',
						],
					],

					[
						'id' => 'stickyHeaderButtonFontColor',
						'label' => __('Sticky State', 'blocksy'),
						'condition' => [
							'row' => '!offcanvas',
							'builderSettings/has_sticky_header' => 'yes',
						],
					],
				],
				'options' => [

					'headerButtonFontColor' => [
						'label' => __( 'Label Text Color', 'blocksy' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'value' => [
							'default' => [
								'color' => Blocksy_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Blocksy_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'default_2' => [
								'color' => 'var(--theme-button-background-initial-color)',
							],

							'hover_2' => [
								'color' => '#ffffff',
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'blocksy' ),
								'id' => 'default',
								'inherit' => 'var(--theme-button-text-initial-color)',
								'condition' => [ 'header_button_type' => 'type-1' ]
							],

							[
								'title' => __( 'Hover', 'blocksy' ),
								'id' => 'hover',
								'inherit' => 'var(--theme-button-text-hover-color)',
								'condition' => [ 'header_button_type' => 'type-1' ]
							],

							[
								'title' => __( 'Initial', 'blocksy' ),
								'id' => 'default_2',
								'condition' => [ 'header_button_type' => 'type-2' ]
							],

							[
								'title' => __( 'Hover', 'blocksy' ),
								'id' => 'hover_2',
								'condition' => [ 'header_button_type' => 'type-2' ]
							],
						],
					],

					'transparentHeaderButtonFontColor' => [
						'label' => __( 'Label Text Color', 'blocksy' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'value' => [
							'default' => [
								'color' => Blocksy_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Blocksy_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'default_2' => [
								'color' => Blocksy_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover_2' => [
								'color' => Blocksy_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'blocksy' ),
								'id' => 'default',
								'condition' => [ 'header_button_type' => 'type-1' ]
							],

							[
								'title' => __( 'Hover', 'blocksy' ),
								'id' => 'hover',
								'condition' => [ 'header_button_type' => 'type-1' ]
							],

							[
								'title' => __( 'Initial', 'blocksy' ),
								'id' => 'default_2',
								'condition' => [ 'header_button_type' => 'type-2' ]
							],

							[
								'title' => __( 'Hover', 'blocksy' ),
								'id' => 'hover_2',
								'condition' => [ 'header_button_type' => 'type-2' ]
							],
						],
					],

					'stickyHeaderButtonFontColor' => [
						'label' => __( 'Label Text Color', 'blocksy' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'value' => [
							'default' => [
								'color' => Blocksy_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Blocksy_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'default_2' => [
								'color' => Blocksy_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover_2' => [
								'color' => Blocksy_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'blocksy' ),
								'id' => 'default',
								'condition' => [ 'header_button_type' => 'type-1' ]
							],

							[
								'title' => __( 'Hover', 'blocksy' ),
								'id' => 'hover',
								'condition' => [ 'header_button_type' => 'type-1' ]
							],

							[
								'title' => __( 'Initial', 'blocksy' ),
								'id' => 'default_2',
								'condition' => [ 'header_button_type' => 'type-2' ]
							],

							[
								'title' => __( 'Hover', 'blocksy' ),
								'id' => 'hover_2',
								'condition' => [ 'header_button_type' => 'type-2' ]
							],
						],
					],
				],
			],


			blocksy_rand_md5() => [
				'type' => 'ct-condition',
				'condition' => [ 'has_header_button_secondary_text' => 'yes' ],
				'options' => [

					'headerButtonSecondaryLabelFont' => [
						'type' => 'ct-typography',
						'label' => __( 'Secondary Label Text Font', 'blocksy' ),
						'value' => blocksy_typography_default_values([
							'size' => '12px',
						]),
						'setting' => [ 'transport' => 'postMessage' ],
					],

					blocksy_rand_md5() => [
						'type' => 'ct-labeled-group',
						'label' => __( 'Secondary Label Text Color', 'blocksy' ),
						'divider' => 'bottom',
						'responsive' => true,
						'choices' => [
							[
								'id' => 'headerButtonSecondaryFontColor',
								'label' => __('Default State', 'blocksy')
							],

							[
								'id' => 'transparentHeaderButtonSecondaryFontColor',
								'label' => __('Transparent State', 'blocksy'),
								'condition' => [
									'row' => '!offcanvas',
									'builderSettings/has_transparent_header' => 'yes',
								],
							],

							[
								'id' => 'stickyHeaderButtonSecondaryFontColor',
								'label' => __('Sticky State', 'blocksy'),
								'condition' => [
									'row' => '!offcanvas',
									'builderSettings/has_sticky_header' => 'yes',
								],
							],
						],
						'options' => [

							'headerButtonSecondaryFontColor' => [
								'label' => __( 'Label Text Color', 'blocksy' ),
								'type'  => 'ct-color-picker',
								'design' => 'block:right',
								'responsive' => true,
								'value' => [
									'default' => [
										'color' => Blocksy_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'hover' => [
										'color' => Blocksy_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'default_2' => [
										'color' => Blocksy_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'hover_2' => [
										'color' => Blocksy_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'blocksy' ),
										'id' => 'default',
										'condition' => [ 'header_button_type' => 'type-1' ]
									],

									[
										'title' => __( 'Hover', 'blocksy' ),
										'id' => 'hover',
										'condition' => [ 'header_button_type' => 'type-1' ]
									],

									[
										'title' => __( 'Initial', 'blocksy' ),
										'id' => 'default_2',
										'condition' => [ 'header_button_type' => 'type-2' ]
									],

									[
										'title' => __( 'Hover', 'blocksy' ),
										'id' => 'hover_2',
										'condition' => [ 'header_button_type' => 'type-2' ]
									],
								],
							],

							'transparentHeaderButtonSecondaryFontColor' => [
								'label' => __( 'Label Text Color', 'blocksy' ),
								'type'  => 'ct-color-picker',
								'design' => 'block:right',
								'responsive' => true,
								'value' => [
									'default' => [
										'color' => Blocksy_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'hover' => [
										'color' => Blocksy_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'default_2' => [
										'color' => Blocksy_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'hover_2' => [
										'color' => Blocksy_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'blocksy' ),
										'id' => 'default',
										'condition' => [ 'header_button_type' => 'type-1' ]
									],

									[
										'title' => __( 'Hover', 'blocksy' ),
										'id' => 'hover',
										'condition' => [ 'header_button_type' => 'type-1' ]
									],

									[
										'title' => __( 'Initial', 'blocksy' ),
										'id' => 'default_2',
										'condition' => [ 'header_button_type' => 'type-2' ]
									],

									[
										'title' => __( 'Hover', 'blocksy' ),
										'id' => 'hover_2',
										'condition' => [ 'header_button_type' => 'type-2' ]
									],
								],
							],

							'stickyHeaderButtonSecondaryFontColor' => [
								'label' => __( 'Label Text Color', 'blocksy' ),
								'type'  => 'ct-color-picker',
								'design' => 'block:right',
								'responsive' => true,
								'value' => [
									'default' => [
										'color' => Blocksy_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'hover' => [
										'color' => Blocksy_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'default_2' => [
										'color' => Blocksy_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],

									'hover_2' => [
										'color' => Blocksy_Css_Injector::get_skip_rule_keyword('DEFAULT'),
									],
								],

								'pickers' => [
									[
										'title' => __( 'Initial', 'blocksy' ),
										'id' => 'default',
										'condition' => [ 'header_button_type' => 'type-1' ]
									],

									[
										'title' => __( 'Hover', 'blocksy' ),
										'id' => 'hover',
										'condition' => [ 'header_button_type' => 'type-1' ]
									],

									[
										'title' => __( 'Initial', 'blocksy' ),
										'id' => 'default_2',
										'condition' => [ 'header_button_type' => 'type-2' ]
									],

									[
										'title' => __( 'Hover', 'blocksy' ),
										'id' => 'hover_2',
										'condition' => [ 'header_button_type' => 'type-2' ]
									],
								],
							],
						],
					],

				],
			],


			blocksy_rand_md5() => [
				'type' => 'ct-labeled-group',
				'label' => __( 'Button Color', 'blocksy' ),
				'responsive' => true,
				'choices' => [
					[
						'id' => 'headerButtonForeground',
						'label' => __('Default State', 'blocksy')
					],

					[
						'id' => 'transparentHeaderButtonForeground',
						'label' => __('Transparent State', 'blocksy'),
						'condition' => [
							'row' => '!offcanvas',
							'builderSettings/has_transparent_header' => 'yes',
						],
					],

					[
						'id' => 'stickyHeaderButtonForeground',
						'label' => __('Sticky State', 'blocksy'),
						'condition' => [
							'row' => '!offcanvas',
							'builderSettings/has_sticky_header' => 'yes',
						],
					],
				],
				'options' => [

					'headerButtonForeground' => [
						'label' => __( 'Button Color', 'blocksy' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'value' => [
							'default' => [
								'color' => Blocksy_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Blocksy_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'blocksy' ),
								'id' => 'default',
								'inherit' => 'var(--theme-button-background-initial-color)'
							],

							[
								'title' => __( 'Hover', 'blocksy' ),
								'id' => 'hover',
								'inherit' => 'var(--theme-button-background-hover-color)'
							],
						],
					],

					'transparentHeaderButtonForeground' => [
						'label' => __( 'Button Color', 'blocksy' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'value' => [
							'default' => [
								'color' => Blocksy_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Blocksy_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'blocksy' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover', 'blocksy' ),
								'id' => 'hover',
							],
						],
					],

					'stickyHeaderButtonForeground' => [
						'label' => __( 'Button Color', 'blocksy' ),
						'type'  => 'ct-color-picker',
						'design' => 'block:right',
						'responsive' => true,
						'value' => [
							'default' => [
								'color' => Blocksy_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],

							'hover' => [
								'color' => Blocksy_Css_Injector::get_skip_rule_keyword('DEFAULT'),
							],
						],

						'pickers' => [
							[
								'title' => __( 'Initial', 'blocksy' ),
								'id' => 'default',
							],

							[
								'title' => __( 'Hover', 'blocksy' ),
								'id' => 'hover',
							],
						],
					],
				],
			],


			blocksy_rand_md5() => [
				'type' => 'ct-divider',
			],

			'headerCtaRadius' => [
				'label' => __( 'Border Radius', 'blocksy' ),
				'type' => 'ct-spacing',
				'value' => blocksy_spacing_value(),
				'responsive' => true
			],

			'headerCtaPadding' => [
				'label' => __( 'Padding', 'blocksy' ),
				'type' => 'ct-spacing',
				'divider' => 'top',
				'value' => blocksy_spacing_value(),
				'responsive' => true
			],

			'headerCtaMargin' => [
				'label' => __( 'Margin', 'blocksy' ),
				'type' => 'ct-spacing',
				'divider' => 'top',
				'value' => blocksy_spacing_value(),
				'responsive' => true,
			],

		],
	],
];
